package cn.com.duiba.kjy.api.dto;

import cn.com.duiba.kjy.api.constant.ContentTypeEnum;
import cn.com.duiba.kjy.api.dto.activity.ActivityExtDto;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Objects;

/**
 * Created by zhangshun on 2019/2/12.
 */
@Data
@ToString
public class ContentExtDto extends ContentDto {

    private static final long serialVersionUID = -1810411219093568114L;
    /**
     *
     *内容头部
     */
    private String contentHead;

    /**
     *
     *内容主体
     */
    private String contentText;

    private String tag1Ids;

    private String tag2Ids;
	
	 /**
     * 朋友圈分享配文
     */
    private String shareDocument;

    /**
     * 公司ID集合
     */
    private String companyIds;

    /**
     * 推荐语
     */
    private String recommendDesc;

    /**
     * 是否收集客户资料 0=不收集；1=收集
     */
    private Boolean isCollectCustomData;

    /**
     * 需要收集资料的字段ids
     */
    private List<Long> customizeFields;

    /**
     * 热榜时效,0:不限时效，1:发布当日可见
     */
    private Integer isDayVisible;

    /**
     * 用于判断是否是抽奖类的活动
     * 老活动全部下掉之后，本方法就可以删除了，改为用 ContentTypeEnum 判断是否是抽奖类型！！！！
     * @return true-抽奖类活动，false-非抽奖类活动
     */
    public boolean isLottery() {
        if (StringUtils.equals(getContentType(), ContentTypeEnum.GAME_LOTTERY.getCode())) {
            return true;
        }
        if (StringUtils.equals(getContentType(), ContentTypeEnum.GAME_TEMPLATE.getCode())) {
            return true;
        }
        if (!StringUtils.equals(getContentType(), ContentTypeEnum.ACTIVITY.getCode())) {
            return false;
        }
        ActivityExtDto activityExtDto;
        try {
            activityExtDto = JSON.parseObject(contentText, ActivityExtDto.class);
        } catch (Exception e) {
            return false;
        }
        return Objects.nonNull(activityExtDto) && Objects.nonNull(activityExtDto.getLottery()) && activityExtDto.getLottery() == 1;
    }

}
