package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.PayResultDto;
import cn.com.duiba.kjy.api.dto.SellerPayRecordDto;
import cn.com.duiba.kjy.api.dto.UserDto;
import cn.com.duiba.kjy.api.dto.seller.SellerPayMoneyTotalDto;
import cn.com.duiba.kjy.api.params.PayOrderManageParam;
import cn.com.duiba.kjy.api.params.seller.SellerPayRecordParams;

import java.util.List;

/**
 * Created by zhangshun on 2019/2/20.
 */
@AdvancedFeignClient
public interface RemoteSellerPayRecordService {

    /**
     * 根据销售员ID和支付状态查询
     * @param sellerId
     * @return
     */
    SellerPayRecordDto findBySellerWaitInPay(Long sellerId);

    /**
     * 获取交易号
     * @return
     */
    SellerPayRecordDto addPayRecord(SellerPayRecordDto dto);

    /**
     * 更新状态
     * 当数据库中订单状态已经是最终状态@see SellerPayStatusEnum.immutableStatusList 时
     * 不能修改
     * @param id ID
     * @param status 状态值
     * @return
     */
    Boolean updateStatus(Long id, Integer status);

    Boolean error(String tradeNum, String errorMessage);

    /**
     * 根据交易号查询
     * @param tradeNo 交易流水号
     * @return
     */
    SellerPayRecordDto findByTradeNo(String tradeNo);

    /**
     * 支付结果处理
     * @param payResultDto
     * @return
     */
    Boolean handlePayResult(PayResultDto payResultDto);

    /**
     * 创建兑吧订单成功后，将兑吧订单号回填到客集集购买记录里
     * @param
     * @param duibaTradeNo
     * @return
     */
    int updateDuibaTradeNo(String tradeNo,String duibaTradeNo);

    Boolean updatePresentUserId(Long id, Long presentUserId);

    List<SellerPayRecordDto> selectList(SellerPayRecordDto pojo);

    /**
     * 根据销售员ID和支付状态查询条数
     * @param sellerId
     * @param payStatus
     * @return
     */
    int findCountBySellerAndStatus(Long sellerId, Integer payStatus);

    /**
     * 批量获取销售员付费金额总数
     * @param sellerIds
     * @return
     */
    List<SellerPayMoneyTotalDto> findSellerPayMoneyTotal(List<Long> sellerIds);

    /**
     * 列表查询
     * @param payRecordParams
     * @return
     */
    List<SellerPayRecordDto> findByParam(SellerPayRecordParams payRecordParams);

    /**
     * 根据 支付订单管理查询页面查询条件筛选支付订单
     */
    List<SellerPayRecordDto> findSellerPayRecordByCondition(PayOrderManageParam condition);

    /**
     * 计数
     */
    Long  countSellerPayRecordByCondition(PayOrderManageParam condition);

    /**
     * 查询最近支付成功的用户信息
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<UserDto> selectRecentlyPaySuccessUserList(Integer pageIndex, Integer pageSize);
}
