package cn.com.duiba.kjy.api.remoteservice.accurateTag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.tag.TagAddDto;
import cn.com.duiba.kjy.api.dto.tag.TagDetailDto;
import cn.com.duiba.kjy.api.dto.tag.TagDto;

import java.util.List;

/**
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemoteAccurateTagService {

    /**
     * 添加
     * @param tagAddDto
     * @return
     */
    Boolean add(TagAddDto tagAddDto);

    /**
     * 新增并且返回id
     * @param tagAddDto
     * @return
     */
    Long addAndRtId(TagAddDto tagAddDto);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 编辑
     * @param tagDto
     * @return
     */
    Boolean update(TagDto tagDto);

    /**
     * 查询标签详细信息
     * @param id
     * @return
     */
    TagDetailDto findDetail(Long id);

    /**
     * 根据上级标签ID获取下级标签列表数据
     * @param parentTagId
     * @return
     */
    List<TagDto> findByParentTagId(Long parentTagId);

    /**
     * 获取下级标签数量
     * @param parentTagId
     * @return
     */
    long countByParentTagId(Long parentTagId);

    /**
     * 获取存在下级标签的上级标签ID集合
     * @param parentTagIds
     * @return
     */
    List<Long> findExitsLowTag(List<Long> parentTagIds);

    /**
     * 查询
     * @param id
     * @return
     */
    TagDto findById(Long id);

    /**
     * 获取所有标签信息
     * @return
     */
    List<TagDto> findAll();

    /**
     * 根据标签分类和级别查询
     * @param tagType
     * @return
     */
    List<TagDto> findByTagTypeAndLevel(String tagType, Integer tagLevel);

    /**
     * 根据标签级别查询
     * @param tagLevel
     * @return
     */
    List<TagDto> findByTagLevel(Integer tagLevel);

    List<TagDto> findByType(String type);
	
    /**
     * 批量查询
     * @param ids
     * @return
     */
    List<TagDto> listByIds(List<Long> ids);

    /**
     * 根据标签类型和名称获取(名称仅支持全匹配查询)
     * @param tagType
     * @param tagName
     * @return
     */
    List<TagDto> findByTagTypeAndName(String tagType, String tagName);
}
