package cn.com.duiba.kjy.api.remoteservice.animation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.animation.AnimationCategoryDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.animation.AnimationCategoryParams;

/**
 * @author lizhi
 * @date 2019/8/23 12:03 PM
 */
@AdvancedFeignClient
public interface RemoteAnimationCategoryService {

    /**
     * 保存分类
     * @param dto 分类信息
     * @return 主键
     */
    Long save(AnimationCategoryDto dto);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 分类详情
     */
    AnimationCategoryDto findById(Long id);

    /**
     * 分页查询
     * @param params 查询参数
     * @return 分类列表
     */
    Page<AnimationCategoryDto> selectPage(AnimationCategoryParams params);

    /**
     * 根据主键逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    int deleted(Long id);
}
