package cn.com.duiba.kjy.api.enums.comment;

import cn.com.duiba.kjy.api.enums.content.RecommendStateEnum;

import java.util.Objects;

/**
 * 评论是否敏感枚举类
 * @author 吴文哲
 * @date 2019-11-27 14:39
 **/
public enum CommentSensitiveEnum {

    UNKNOW(0, "未知"),
    SENSITIVE(1, "内容包含敏感信息"),
    NOT_SENSITIVE(2, "内容不包含敏感信息"),
    ;

    private Integer type;

    private String desc;

    CommentSensitiveEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static CommentSensitiveEnum getByType(Integer type) {
        for (CommentSensitiveEnum enumVal : CommentSensitiveEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
