package cn.com.duiba.kjy.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.fission.FissionAwardContextDto;
import cn.com.duiba.kjy.api.params.fission.FissionAwardContextQueryParam;

import java.util.List;

/**
 * 奖品对话内容相关
 * @author lizhi
 * @date 2019/12/16 10:08 AM
 */
@AdvancedFeignClient
public interface RemoteFissionAwardContextService {

    /**
     * 查询列表
     * @param param 条件
     * @return 奖品对话列表
     */
    List<FissionAwardContextDto> findListByParam(FissionAwardContextQueryParam param);

    /**
     * 批量新增更新或删除
     * @param awardId 奖品ID
     * @param templateType 几度人脉
     * @see cn.com.duiba.kjy.api.enums.fission.FissionAwardContextTemplateEnum
     * @param chatStage 第几阶段
     * @see cn.com.duiba.kjy.api.enums.fission.FissionChatTypeEnum
     * @param dtos 对话信息
     * @return 执行结果
     */
    int batchSaveOrUpdateOrDelete(Long awardId, Integer templateType, Integer chatStage, List<FissionAwardContextDto> dtos);
}
