package cn.com.duiba.kjy.api.dto.sellercard;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Created by dugq on 2019-07-29.
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AuthenticationDto implements Serializable {
    private static final long serialVersionUID = -5241420278279513105L;

    /**
     * AuthTypeEnum
     */
    @Deprecated
    private Byte authType;

    /**
     * 是否开启
     */
    private Boolean open;

    /**
     * 代理人配置key
     */
    private String configKey;

    /**
     * 荣誉认证名称
     */
    private String honorName;

    /**
     * 荣誉图片 以,分割
     */
    private String honorPics;

    /**
     * 荣誉简介
     */
    private String honorIntroduction;

    public AuthenticationDto(Byte authType, Boolean open, String configKey) {
        this.authType = authType;
        this.open = open;
        this.configKey = configKey;
    }

}
