package cn.com.duiba.kjy.api.dto.honorauth;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 荣誉认证配置表
 * @author kjj mybatis generator 
 * 2019-12-30
 */
@Data
public class HonorAuthDto implements Serializable {
    private static final long serialVersionUID = 15776922951634044L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *荣誉key,对应tb_seller_config.config_key
     * max length = 30
     * not null default = null
     */
    private String honorKey;

    /**
     *
     *荣誉名称
     * max length = 48
     * not null default = null
     */
    private String honorName;

    /**
     *
     *荣誉简介
     * max length = 300
     * not null default = null
     */
    private String honorIntroduction;

    /**
     *
     *荣誉图片,hbaseKey
     * max length = 100
     * not null default = 
     */
    private String honorPics;

    /**
     *
     *排序
     * not null default = null
     */
    private Long sort;

    /**
     *
     *状态 1:开启 2:关闭  
     * not null default = 2
     */
    private Byte state;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}