package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.company.CompanyNewsDto;
import cn.com.duiba.kjy.api.params.company.CompanyNewsMoveParam;
import cn.com.duiba.kjy.api.params.company.CompanyNewsParam;

import java.util.List;

/**
 * 公司动态
 * @author 吴文哲
 * @date 2019-12-28 13:39
 **/
@AdvancedFeignClient
public interface RemoteCompanyNewsService {

    /**
     * 新增公司动态
     * @param dto
     * @return
     */
    Integer addCompanyNews(CompanyNewsDto dto);

    /**
     * 修改公司动态
     * @param dto
     * @return
     */
    Integer updateCompanyNews(CompanyNewsDto dto);

    /**
     * 删除公司动态
     * @param dto
     * @return
     */
    Integer delCompanyNews(CompanyNewsDto dto);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<CompanyNewsDto> getNewsList(CompanyNewsParam param);

    /**
     * 根据公司id统计
     * @param param
     * @return
     */
    Integer countNewsList(CompanyNewsParam param);

    /**
     * 公司动态移动位置
     * @param param
     * @return
     */
    Boolean moveCompanyNews(CompanyNewsMoveParam param);
}
