package cn.com.duiba.kjy.api.enums.seller;

/**
 * 可返现状态
 * * @author zhanghuifeng
 * date 2019-05-21-11:20
 */
public enum PromotionStateEnum {

    CAN_PROMOTION(0, "可返现"),
    UN_PROMOTION(1, "不可返现"),
    ;
    private Integer code;

    private String desc;

    PromotionStateEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static PromotionStateEnum getByCode(Integer code) {
        for (PromotionStateEnum enumVal : PromotionStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (PromotionStateEnum enumVal : PromotionStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
