package cn.com.duiba.kjy.api.enums.user;

import java.util.HashMap;
import java.util.Map;

/**
 * 微信事件类型
 * @author lizhi
 * @date 2019/12/3 5:14 PM
 */
public enum WxEventTypeEnum {

    SUBSCRIBE("subscribe", "关注公众号"),
    UNSUBSCRIBE("unsubscribe", "取消关注公众号"),
    SCAN("SCAN", "扫描二维码"),
    LOCATION("LOCATION", "上报地理位"),
    CLICK("CLICK", "点击菜单拉取消息"),
    VIEW("VIEW", "点击菜单跳转链接"),
    ;

    private String type;

    private String desc;

    WxEventTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<String, WxEventTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WxEventTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static WxEventTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 是否是有效交互
     * @param type 类型
     * @return true-是，false-否
     */
    public static boolean isInteraction(String type) {
        WxEventTypeEnum typeEnum = getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == SUBSCRIBE || typeEnum == SCAN
                || typeEnum == CLICK || typeEnum == VIEW;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
