package cn.com.duiba.kjy.api.dto.privatechat;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 私聊信息微信推送Dto
 * @Auther: Tt(yehuawei)
 * @Date: 2019/7/2 0002 13:58
 */
@Data
public class ChatWxOaPushMessageDto extends WxMessageReceiverInfoDto implements Serializable {
    private static final long serialVersionUID = -2822577642338024834L;

    /**
     * 触发事件
     */
    private String triggerEvent;
    /**
     * 会话id
     */
    private String sessionId;

    /**
     * 客户名称
     */
    private String userName;

    /**
     * 接收人的用户id
     */
    private Long userId;

    /**
     * 可用的formId
     */
    private String formId;

    /**
     * 消息关键信息，目前使用场景：
     * 1.作为小程序模板消息id
     */
    private String key;

    /**
     * 模版消息内容
     */
    private String data;

    /**
     * 客户手机号
     */
    private String userPhone;

    /**
     * 咨询时间
     */
    private Date ConsultationTime;

    /**
     * 咨询内容
     */
    private String content;


    /**
     * 代理人名称
     */
    private String sellerName;
    /**
     * 代理人手机号
     */
    private String sellerPhone;
    /**
     * 跳转地址
     */
    private String gotoUrl;
}
