package cn.com.duiba.kjy.api.enums.pay;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/1/8 11:26 AM
 */
public enum CompanyPayStatusEnum {

    INIT(0, "初始化状态"),
    PROCESSING(1,"处理中"),
    SUCCESS(2, "转账成功"),
    FAILED(3, "转账失败"),
    CALL_FAILED(4, "调用微信失败"),
    ;

    private Integer code;
    private String desc;

    CompanyPayStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, CompanyPayStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CompanyPayStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static CompanyPayStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static CompanyPayStatusEnum getByWxStatus(String wxStatus) {
        if (wxStatus == null) {
            return null;
        }
        WxCompanyPayStatusEnum statusEnum = WxCompanyPayStatusEnum.getByCode(wxStatus);
        if (statusEnum == null) {
            return null;
        }
        switch (statusEnum) {
            case SUCCESS:
                return SUCCESS;
            case FAILED:
                return FAILED;
            case PROCESSING:
                return PROCESSING;
            default:
                return null;
        }
    }

}
