package cn.com.duiba.kjy.api.params;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2019-02-18 15:38
 * @description: 编辑我的客户参数
 */
@Data
@ToString
public class EditCustomerParam implements Serializable {

    private static final long serialVersionUID = -3476230339429888053L;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 备注名称
     */
    private String remarkName;

    /**
     *
     *备注名称拼音
     */
    private String remarkNamePinyin;

    /**
     *
     *备注名称拼音,首字母
     */
    private String remarkNamePinyinFast;

    /**
     * 顾客电话
     */
    private String custPhone;

    /**
     * 顾客意向，企业产品ID，多个英文逗号隔开
     */
    private String custTag;

    /**
     * 顾客：备注
     */
    private String custRemark;

    /**
     * 顾客：省
     */
    private String custProvince;

    /**
     * 顾客：市
     */
    private String custCity;

    /**
     * 顾客: 区
     */
    private String custArea;

    /**
     *
     *最后访问时间
     */
    private Date lastVisitTime;

    /**
     * 顾客标志
     */
    private Integer custMark;

    /**
     * 是否与代理人有一级接触
     */
    private Integer isTouched;

    /**
     * 生日(包含是否是阳历，阳历生日)
     */
    private String custBirth;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 客户意向度星级
     */
    private Integer star;

    /**
     * 客户意向度得分
     */
    private Integer score;

    /**
     * 客户来源 1:微信好友 2:二度人脉
     */
    private Integer custOrigin;

    /**
     * 是否为特别关注客户
     * @see  cn.com.duiba.kjy.api.enums.seller.SellerCustomerIsSpecialEnum
     */
    private Integer isSpecialCustomer;
}
