package cn.com.duiba.kjy.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.ContentDto;
import cn.com.duiba.kjy.api.dto.greeting.ContentGreetingCardExtDetailDto;
import cn.com.duiba.kjy.api.dto.greeting.ContentGreetingCardExtDto;
import cn.com.duiba.kjy.api.dto.greeting.ContentGreetingCardSpareWordsDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.activity.ContentGreetingCardSearchParams;

import java.util.List;

/**
 * 贺卡相关
 * @author lizhi
 * @date 2019/12/18 2:24 PM
 */
@AdvancedFeignClient
public interface RemoteContentGreetingCardService {

    /**
     * 分页查询-管理后台专用
     * @param params 分页参数
     * @return 贺卡列表及分页参数
     */
    Page<ContentDto> findPage(ContentGreetingCardSearchParams params);

    /**
     * 分页查询-用于手机端
     * @param params 分页参数
     * @return 贺卡列表
     */
    List<ContentDto> findPageList(ContentGreetingCardSearchParams params);

    /**
     * 根据贺卡ID查询
     * @param id 贺卡ID，对应tb_content.id
     * @return 贺卡详情
     */
    ContentGreetingCardExtDetailDto findById(Long id);

    /**
     * 根据贺卡ID查询扩展信息
     * @param id 贺卡ID，对应tb_content.id
     * @return 贺卡扩展信息
     */
    ContentGreetingCardExtDto findExtById(Long id);

    /**
     * 根据贺卡ID查询备用祝福语
     * @param id 贺卡ID
     * @return 备用祝福语集合
     */
    List<ContentGreetingCardSpareWordsDto> findSpareWordsById(Long id);

    /**
     * 新增或更新
     * @param dto 贺卡详情
     * @return 执行结果
     * @throws KjyCenterException 新增或更新失败的自定义异常
     */
    Long saveOrUpdate(ContentGreetingCardExtDetailDto dto) throws KjyCenterException;

    /**
     * 获取已上线的贺卡数量
     * @return
     */
    Integer countNormalGreetingCard();
}
