package cn.com.duiba.kjy.api.dto.explosionContent;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 爆款素材文章表
 * @author kjj mybatis generator 
 * 2020-01-06
 */
@Data
public class ExplosionContentDto implements Serializable {
    private static final long serialVersionUID = 15783079894297007L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *tb_content主键ID
     */
    private Long contentId;

    /**
     *
     *tb_admin_article_collection主键ID
     */
    private Long articleCollectionId;

    /**
     *
     *精准素材类型 1:爆款素材 2:必转素材
     * not null default = null
     */
    private Byte explosionContentType;

    /**
     * 对应 TagTypeEnum
     */
    private Long classify;

    /**
     *
     *文章内标签，最多三个标签，每个标签不超过6个字，标签之间用英文逗号隔开
     * max length = 255
     * not null default = 
     */
    private String tags;

    /**
     *
     *推荐理由
     * max length = 255
     * not null default = 
     */
    private String recommendReason;

    /**
     * 问答id列表
     */
    private List<Long> qaIds;

    /**
     * 私信小科普id
     */
    private Long knowledgeId;

    /**
     *
     *自定义标签
     */
    private Long customTag;

    /**
     *
     *发布时间
     */
    private Date releaseTime;

    /**
     *
     *内容状态:0:不可用 1:可用
     * not null default = 0
     */
    private Byte contentStatus;

    /**
     *
     *险种属性标签id，对应tb_accurate_tag的主键id
     */
    private Long insurancePropertyTag;

    /**
     *
     *转发量
     * not null default = 0
     */
    private Integer shareNum;

    /**
     *
     *是否删除，1=已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}