package cn.com.duiba.kjy.api.remoteservice.explosioncontent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.explosionContent.ExplosionContentDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;

/**
 * @Author chentiecheng
 * @Date 2020/1/6 7:42 下午
 */
@AdvancedFeignClient
public interface RemoteExplosionContentService {

    /**
     * 从文章管理新增或者更新爆款素材
     * @param explosionContentDto
     * @return
     */
    Boolean addOrUpdateExplosionContent(ExplosionContentDto explosionContentDto);


    /**
     * 根据文章id 删除爆款/必转素材
     * @param contentId
     * @return
     */
    Integer deleteExplosionContentId(Long contentId);

    /**
     * 根据id查询爆款素材
     * @param id
     * @return
     */
    ExplosionContentDto selectById(Long id);

    /**
     * 分页查询爆款素材列表
     * @param pageQuery
     * @return
     */
    List<ExplosionContentDto> selectPageByContentIdNotNull(PageQuery pageQuery);

    /**
     * 查询爆款文章总数
     * @return
     */
    Long selectCountByContentIdNotNull();

    /**
     * 同步文章
     * @param explosionContentDto
     * @return
     */
    Boolean syncExplosion(ExplosionContentDto explosionContentDto);

    /**
     * 从爆款文章列表 编辑爆款文章
     * @param explosionContentDto
     * @return
     */
    Boolean updateExplosion(ExplosionContentDto explosionContentDto);
}
