package cn.com.duiba.kjy.api.remoteservice.explosioncontent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.explosionContentQuestion.ExplosionContentQuestionDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.explosionContent.QAPageQryParams;

/**
 * 爆款素材问答服务
 * Created by hong
 * time 2020/1/6 20:28.
 */
@AdvancedFeignClient
public interface RemoteQAService {
    /**
     * 新增
     *
     * @param dto
     * @return
     */
    Boolean add(ExplosionContentQuestionDto dto);

    /**
     * 分页查询
     *
     * @param params
     * @return
     */
    Page<ExplosionContentQuestionDto> findPageList(QAPageQryParams params);

    /**
     * 编辑
     *
     * @param dto
     * @return
     */
    Boolean update(ExplosionContentQuestionDto dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);


    /**
     * 通过问答id查询爆款素材数量
     * @param qaId 问答id
     * @return
     */
    int findCountByQAid(Long qaId);
}
