package cn.com.duiba.kjy.api.enums.accurate;

import java.util.stream.Stream;

/**
 * 精准素材标签类型枚举
 *
 * @author xiaotian
 * date 2019-12-13-17:13
 */
public enum TagTypeEnum {

    /**
     * 精准素材1.0版本标签type
     */
    ARTICLE("article", "文章"),

    /**
     * 精准素材2.0
     */
    ACCURATE("accurate", "精准素材"),

    /**
     * 险种
     */
    INSURANCE("insurance", "险种"),

    /**
     * 人群
     */
    CROWD("crowd", "人群"),

    /**
     * 产品
     */
    PRODUCT("product", "产品"),

    /**
     * 保险理念对应 id101
     */
    INSURANCECONCEPT("insuranceConcept", "保险理念",101L),

    /**
     * 保险产品对应 id102
     */
    INSURANCEPRODUCTS("insuranceProducts", "保险产品",102L),

    /**
     * 增员 对应 id103
     */
    INCREASESTAFF("increaseStaff", "增员",103L),
    ;

    private String code;

    private String desc;

    private Long   id;

    TagTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    TagTypeEnum(String code, String desc, Long id) {
        this.code = code;
        this.desc = desc;
        this.id   = id;
    }


    public static AccurateSortTypeEnum getByCode(String code) {
        return Stream.of(AccurateSortTypeEnum.values()).filter(accurateSortTypeEnum -> accurateSortTypeEnum.getType().equals(code)).findFirst().orElse(null);
    }

    public static String getDescByCode(String code) {
        for (TagTypeEnum enumVal : TagTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Long getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }
}
