package cn.com.duiba.kjy.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.contentarticle.AdminArticleCollectionDto;
import cn.com.duiba.kjy.api.params.content.ArticleListParam;

import java.util.Date;
import java.util.List;

/**
 * Created by dugq on 2019-11-16.
 */
@AdvancedFeignClient
public interface RemoteAdminArticleCollectionService {

    AdminArticleCollectionDto selectOne(Long id);

    /**
     * 插入一条新收藏
     * @param dto
     * @return 记录ID
     */
    Long insert(AdminArticleCollectionDto dto);

    /**
     * 为已经定时的收藏文章排序
     *
     * @param id
     * @param type
     * @return  已经发布的或者未定时的 return 0;
     */
    int sort(Long id ,Byte type);

    /**
     * 列表查询
     * @param param
     * @return
     */
    List<AdminArticleCollectionDto> selectList(ArticleListParam param);

    /**
     * 根据标签查询列表
     * 此筛选为了方便运营编辑多个标签下编辑文章
     * 查询条件：时间，标签，操作人 都不能为空，否则不允许查询
     * @param param
     * @return
     */
    List<AdminArticleCollectionDto> selectListByTag(ArticleListParam param);

    AdminArticleCollectionDto selectOneByContentId(Long contentId);

    /**
     * 和查询配套使用
     * 查询数量
     * @param param
     * @return
     */
    long selectCount(ArticleListParam param);

    /**
     * 批量定时,并设置标签
     * @param ids
     * @param time
     * @return
     */
    int batchTimingOpen(List<Long> ids, Date time,List<Long> firstTagId);

    /**
     * 批量删除
     * @param ids
     * @return 返回删除条数
     */
    int batchDelete(List<Long> ids);

    /**
     * 发布
     * @return
     */
    Long publish(Long id,boolean publish) throws KjyCenterException;

    /**
     * 撤回
     * @param id
     * @return
     */
    int recall(Long id);


    int update(AdminArticleCollectionDto dto);


    /**
     *   上：
     *    查询出在目标文章上面（pay_load > target）的同时发布文章
     *    根据tagId和operator过滤,找出上一个元素
     *    两者之间的元素，包括上一个元素下移，修改目标文章pay_load = 上一个元素的pay_load
     *    下：
     *    查询出在目标文章下面（pay_load < target）的同时发布文章
     *    根据tagId和operator过滤,找出下一个元素
     *    两者之间的元素，包括下一个元素上移，修改目标文章pay_load = 下一个元素的pay_load
     *
     * @param id
     * @param type 1:上 2：下
     * @param tagId
     * @param operator
     * @return
     */
    int sortByTagAndOperator(Long id, Byte type, Long tagId, String operator);
}
