package cn.com.duiba.kjy.api.dto.animation;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 动画
 * @author lizhi
 * @date 2019-08-23
 */
@Data
public class AnimationDto implements Serializable {

    private static final long serialVersionUID = 15665503749319127L;

    /**
     * appId， 预览和正式通过改ID关联
     */
    private Long appId;

    /**
     * 动画名称
     */
    private String animationName;

    /**
     * 动画图片
     */
    private String animationImg;

    /**
     * 动画描述
     */
    private String animationDesc;

    /**
     * 动画插件，由前端定义值
     */
    private String plugins;

    /**
     * 动画类型，0-预览，1-正式
     * @see cn.com.duiba.kjy.api.enums.animation.AnimationTypeEnum
     */
    private Integer animationType;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}