package cn.com.duiba.kjy.api.enums.seller;

/**
 * 提现开关枚举
 * @author zhanghuifeng
 * date 2019-05-17-11:04
 */
public enum WithdrawSwitchEnum {

    OPEN(1, "打开"),
    CLOSE(2, "关闭"),
    ;
    private Integer code;

    private String desc;

    WithdrawSwitchEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static WithdrawSwitchEnum getByCode(Integer code) {
        for (WithdrawSwitchEnum enumVal : WithdrawSwitchEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (WithdrawSwitchEnum enumVal : WithdrawSwitchEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
