package cn.com.duiba.kjy.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.usingStrategy.StrategyTagDto;

import java.util.List;

/**
 * @author 吴文哲
 * @date 2020-01-11 14:22
 **/
@AdvancedFeignClient
public interface RemoteStrategyTagService {

    /**
     * 新增/修改 标签
     * @param dto
     * @return
     */
    Integer addOrUpdateTag(StrategyTagDto dto) throws KjyCenterException;

    /**
     * 删除tag
     * @param tagId
     * @return
     */
    Integer delTag(Long tagId) throws KjyCenterException;

    /**
     * 获取所有的标签列表  根据sort倒序
     * @return
     */
    List<StrategyTagDto> getAllTagList();

    /**
     * 已经排好序的所有标签id
     * @param ids
     * @return
     */
    Boolean moveTag(List<Long> ids) throws Exception;
}
