package cn.com.duiba.kjy.api.params.guide;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.io.Serializable;

/**
 * 常见问题查询参数
 * @author 吴文哲
 * @date 2020-01-13 10:18
 **/
@Data
public class StrategyFaqQueryParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = -2502181391520810818L;

    /**
     * 标题
     */
    private String title;

    /**
     * 分类id
     */
    private Long tagId;

    /**
     * @see cn.com.duiba.kjy.api.enums.content.RecommendStateEnum
     * 是否推荐  0:不推荐 1:推荐
     */
    private Integer recommend;

    /**
     * @see cn.com.duiba.kjy.api.enums.guide.UsingStrategyShowStateEnum
     * 1显示 0 不显示
     */
    private Integer showState;


}
