package cn.com.duiba.kjy.api.remoteservice.explosioncontent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.explosionContent.ExplosionContentDto;
import cn.com.duiba.kjy.api.dto.explosionContent.ExplosionContentExtDto;
import cn.com.duiba.kjy.api.dto.explosionContent.RecommendSeeDto;

import java.util.List;
import cn.com.duiba.kjy.api.params.PageQuery;

/**
 * @Author chentiecheng
 * @Date 2020/1/6 7:42 下午
 */
@AdvancedFeignClient
public interface RemoteExplosionContentService {

    /**
     * 从文章管理新增或者更新爆款素材
     * @param explosionContentDto
     * @return
     */
    Boolean addOrUpdateExplosionContent(ExplosionContentExtDto explosionContentDto);


    /**
     * 根据文章id 删除爆款/必转素材
     *
     * @param contentId
     * @return
     */
    Integer deleteExplosionContentId(Long contentId);

    /**
     * 根据id查询爆款素材
     * @param id
     * @return
     */
    ExplosionContentDto selectById(Long id);

    /**
     * 分页查询爆款素材列表
     * @param pageQuery
     * @return
     */
    List<ExplosionContentDto> selectPageByContentIdNotNull(PageQuery pageQuery);

    /**
     * 查询爆款文章总数
     * @return
     */
    Long selectCountByContentIdNotNull();

    /**
     * 同步文章
     * @param explosionContentDto
     * @return
     */
    Boolean syncExplosion(ExplosionContentExtDto explosionContentDto);

    /**
     * 从爆款文章列表 编辑爆款文章
     * @param explosionContentDto
     * @return
     */
    Boolean updateExplosion(ExplosionContentDto explosionContentDto);

    /**
     * 根据文章id查询爆款素材
     * @param contentId
     * @return
     */
    ExplosionContentDto selectByContentId(Long contentId);

    /**
     * 获取必转素材
     * @return
     */
    ExplosionContentDto selectBehooveContent();

    /**
     * 更新必转素材
     * @param explosionContentDto
     * @return
     */
    Boolean updateBehooveContent(ExplosionContentDto explosionContentDto);

    /**
     * 根据id 删除爆款素材
     * @param id
     * @return
     */
    Boolean deleteExplosionContent(Long id);

    /**
     * 查询推荐你看列表
     *
     * @return
     */
    List<RecommendSeeDto> queryRecommendSeeList(Long contentId);

    /**
     * 根据文章id列表 批量删除爆款素材
     * @param contentIds
     * @return
     */
    Integer batchDeleteByContentIds(List<Long> contentIds);

    /**
     * 首页-获取爆款列表(只支持分页查询前10篇)
     * @param pageQuery
     * @return
     */
    List<ExplosionContentDto> selectExplosionContentList(PageQuery pageQuery);

    /**
     * 首页-获取必转内容
     * @return
     */
    ExplosionContentDto selectShareContent();

}
