package cn.com.duiba.kjy.api.remoteservice.gift;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.gift.GiftDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.gift.GiftParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019/7/19 10:35
 * @descript
 */
@AdvancedFeignClient
public interface RemoteGiftService {

    /**
     * 新增或修改赠品
     * @param giftDto
     * @return
     */
    Integer addOrUpdate(GiftDto giftDto);

    /**
     * 分页查询
     * @param param
     * @return
     */
    Page<GiftDto> findPage(GiftParam param);

    /**
     * 列表查询
     * @param param
     * @return
     */
    List<GiftDto> listGift(GiftParam param);

    /**
     * 总数查询
     * @param param
     * @return
     */
    Integer countGiftByParam(GiftParam param);

}
