package cn.com.duiba.kjy.api.enums.clue;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2019-12-30 16:14
 * @descript 访问推送线索
 */
public enum VisitClueTypeEnum {
    NORMAL_VISIT(0, "普通访问"),
    FREQUENTLY_VISIT(1, "连续访问"),
    DEPT_VISIT(2, "深度访问"),
    MATERIAL_VISIT(3, "提交资料的访问"),
    SALE_VISIT(4, "销售机会访问"),
    VOTE_VISIT(5, "投票访问"),
    ANSWER_VISIT(6, "答题访问"),
    LOTTERY_VISIT(7, "中奖访问"),
    PRODUCT_VISIT(8, "产品素材访问"),
    MONTH_ACCUMULATE_VISIT(9, "1个月内累计有效阅读3个保险类素材"),
    PRIVATE_FAQ_VISIT(10, "种草素材-FAQ&私信气泡"),
    CLUE_ACTIVITY_SUBMIT_MATERIAL(11, "线索类小游戏"),
    ;

    private Integer code;
    private String description;

    VisitClueTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据代码返回线索访问类型枚举类
     *
     * @param code
     * @return
     */
    public static VisitClueTypeEnum getByCode(Integer code) {
        for (VisitClueTypeEnum visitClueTypeEnum : VisitClueTypeEnum.values()) {
            if (Objects.equals(visitClueTypeEnum.getCode(), code)) {
                return visitClueTypeEnum;
            }
        }
        return null;
    }

    /**
     * 是否为延迟推送
     * @param code
     * @return
     */
    public static boolean isDelayPush(Integer code) {
        return Objects.equals(NORMAL_VISIT.code, code) || Objects.equals(FREQUENTLY_VISIT.code, code)
                || Objects.equals(DEPT_VISIT.code, code) || Objects.equals(PRODUCT_VISIT.code, code)
                || Objects.equals(MONTH_ACCUMULATE_VISIT.code, code);

    }

}
