package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.distribution.DistributionRecordDto;
import cn.com.duiba.kjy.api.dto.distribution.PrivilegeSellerDisStatisticsDto;
import cn.com.duiba.kjy.api.dto.distribution.SellerToDistributionCountDto;
import cn.com.duiba.kjy.api.enums.seller.DistributionSourceTypeEnum;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.distribution.PrivilegeSellerDisQryParams;

import java.util.Date;
import java.util.List;

/**
 * 分销关系记录服务
 * @author zhanghuifeng
 * date 2019-07-22-20:25
 */
@AdvancedFeignClient
public interface RemoteDistributionRecordService {

    /**
     * 查询特权邀请关系统计信息
     * @param parentSid
     * @param startTime
     * @param endTime
     * @return
     */
    PrivilegeSellerDisStatisticsDto disStatistics(long parentSid, Date startTime , Date endTime);

    Page<DistributionRecordDto> find4Page(PrivilegeSellerDisQryParams param);

    /**
     * 根据上级ID集合和来源类型查询统计数据
     * @param parentSids
     * @param sourceType
     * @see DistributionSourceTypeEnum
     * @return
     */
    List<SellerToDistributionCountDto> countByPIdsAndSourceType(List<Long> parentSids, Integer sourceType);
}
