package cn.com.duiba.kjy.api.dto.seller;

import cn.com.duiba.kjy.api.constant.SellerVipEnum;
import cn.com.duiba.kjy.api.enums.order.IsPaidEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author zhanghuifeng
 * date 2019/11/26-2:43 下午
 */
@Data
public class SellerIdJudgeVipDto implements Serializable {
    private static final long serialVersionUID = -4588693410330171163L;

    /**
     * 是否付费 0-未付费 1-付费
     */
    private Integer isPaid;

    /**
     * 主键
     */
    private Long id;

    /**
     * vip开始时间
     */
    private Date vipBeginTime;

    /**
     * vip结束时间
     */
    private Date vipEndTime;


    /**
     * vip级别，0=不是、1=是
     */
    private Integer vip;


    /**
     * 是否是付费开通会员
     *
     * @return true-是，false-不是
     */
    public boolean isPayVip() {
        if (Objects.isNull(vip) || Objects.isNull(vipEndTime)) {
            return false;
        }

        if (!SellerVipEnum.VIP1.getCode().equals(vip) || new Date().after(vipEndTime)) {
            return false;
        }
        return IsPaidEnum.IS_PAID.getStatus().equals(isPaid);
    }

}
