package cn.com.duiba.kjy.api.enums;

/**
 * @author lizhi
 * @date 2019/7/19 10:53 AM
 */
public enum UsersVisitPushTypeEnum {

    REAL_TIME(1, "实时推送"),
    NON_REAL_TIME(0, "非实时推送"),
    FROM_MORNING_VISIT(2, "访问早报中的内容推送"),
    HAS_SOURCE_VISIT(3, "访问内容详情页中的内容"),
    ;

    private Integer type;

    private String desc;

    UsersVisitPushTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean isNeedPush(Integer type) {
        return REAL_TIME.type.equals(type) || NON_REAL_TIME.type.equals(type) || HAS_SOURCE_VISIT.type.equals(type);
    }

}
