package cn.com.duiba.kjy.api.remoteservice.specialregion;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.specialregion.SpecialRegionContentDto;
import cn.com.duiba.kjy.api.params.specialregion.SpecialRegionContentListParam;

import java.util.List;

/**
 * Created by dugq on 2020-01-23.
 * 文章详情 {@link cn.com.duiba.kjy.api.remoteservice.RemoteContentService }
 */
@AdvancedFeignClient
public interface RemoteSpecialRegionContentService {
    /**
     * 根据ID查询
     * @param id tb_special_region_content 表ID
     * 文章详情 {@link cn.com.duiba.kjy.api.remoteservice.RemoteContentService }
     * @return
     */
    SpecialRegionContentDto selectOne(Long id);

    /**
     * 查询列表
     * 文章详情 {@link cn.com.duiba.kjy.api.remoteservice.RemoteContentService }
     * @param param 查询参数
     * @return
     */
    List<SpecialRegionContentDto> selectList(SpecialRegionContentListParam param);

    /**
     * 跟新
     * @param record 记录
     * @return
     */
    int update(SpecialRegionContentDto record);

    /**
     * 查询数量，分页使用
     * @param param 插叙参数
     * @return
     */
    Integer selectCount(SpecialRegionContentListParam param);

    /**
     * 新增
     * @param pojo
     * @return 成功返回ID，失败返回0
     */
    Long insert(SpecialRegionContentDto pojo);

    /**
     * 物理删除。 数据操作都应该落在内容表上。
     * @param id ID
     * @return
     */
    Integer delete(Long id);
}
