package cn.com.duiba.kjy.api.enums.content;

import java.util.Objects;

/**
 * @auther: linjianhui
 * @date: 2019-12-07 11:43
 * @description: 查询场景
 */
public enum ContentSearchSceneEnum {

    /**
     * 首页，热门动画，精美海报查询场景
     */
    POSTER_MORE(1, "更多海报"),
    POSTER_HOT(2, "最热海报"),
    POSTER_NEW(3, "最新海报"),
    ACTIVITY_MORE(4, "更多动画"),
    ACTIVITY_HOT(5, "最热动画"),
    ACTIVITY_NEW(6, "最新动画"),

    ;
    private Integer code;

    private String desc;

    ContentSearchSceneEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 通过code获取枚举
     * @param code
     * @return
     */
    public static ContentSearchSceneEnum getByCode(Integer code) {
        if (Objects.isNull(code)){
            return null;
        }
        for (ContentSearchSceneEnum enumVal : ContentSearchSceneEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
