package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerPromotionDto;
import cn.com.duiba.kjy.api.params.redpacket.SellerPromotionQueryParam;

import java.util.List;

/**
 * @author liuchao1
 * @date 2020/1/8 16:07
 */
@AdvancedFeignClient
public interface RemoteSellerPromotionService {

    /**
     * 根据主键id查询
     * @param id 主键id
     * @return 代理人优惠信息
     */
    SellerPromotionDto findById(Long id);

    /**
     * 根据查询条件查询代理人优惠信息
     * @param param 查询条件
     * @return 代理人优惠信息集合
     */
    List<SellerPromotionDto> findByParam(SellerPromotionQueryParam param);

    /**
     * 根据id修改优惠信息，目前只能修改状态
     * @param dto 优惠信息
     * @return 更改是否成功
     */
    boolean updateById(SellerPromotionDto dto);

    /**
     * 新增
     * @param dto 代理人优惠信息
     * @return 主键id
     */
    Long save(SellerPromotionDto dto);

    /**
     * 根据id修改状态
     * @param id 主键id
     * @param newState 新状态
     * @param expectState 期望状态
     * @return 执行结果
     */
    boolean updateState(Long id, Integer newState, Integer expectState);
}
