package cn.com.duiba.kjy.api.dto.seller;

import cn.com.duiba.kjy.api.constant.SellerVipEnum;
import cn.com.duiba.kjy.api.enums.order.IsPaidEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author xiaotian
 * date 2020/01/22
 */
@Data
public class SellerIdJudgeVipDto implements Serializable {

    /**
     * 是否付费 0-未付费 1-付费
     */
    private Integer isPaid;

    /**
     * 主键
     */
    private Long id;

    /**
     * vip开始时间
     */
    private Date vipBeginTime;

    /**
     * vip结束时间
     */
    private Date vipEndTime;


    /**
     * vip级别，0=不是、1=是
     */
    private Integer vip;


    /**
     * 是否是付费开通会员
     *
     * @return true-是，false-不是
     */
    public boolean isPayVip() {
        if(Objects.isNull(vipEndTime)){
            return false;
        }
        return  Objects.equals(SellerVipEnum.VIP1.getCode(),vip) && new Date().before(vipEndTime);
    }

}
