package cn.com.duiba.kjy.api.dto.sellercard;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * Created by dugq on 2019-07-29.
 */
@Data
public class CaseDto implements Serializable {
    private static final long serialVersionUID = 3750043947685268067L;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * HBase key
     */
    private String id;

    /**
     * 客户姓名
     */
    private String name;

    /**
     * "0:男 1:女",
     */
    private Integer sex;

    /**
     * 客户年龄
     */
    private Integer age;

    /**
     * 客户年收入
     */
    private String yearIncome;

    /**
     * 案例类型(投保险种)
     */
    private String caseType;

    /**
     * 保费
     */
    private String premium;

    /**
     * 权益
     */
    private String assets;

    /**
     * 案例描述
     */
    private String caseIntro;

    /**
     * 案例图片
     */
    private String casePics;

    /**
     * 必填项是否完善
     */
    private boolean compelete;

    /**
     * 是否完善了客户案例
     * @return
     */
    public boolean isCompelete() {
        if(StringUtils.isBlank(this.name)){
            return false;
        }
        if(StringUtils.isBlank(this.caseType)){
            return false;
        }
        if(StringUtils.isBlank(this.premium)){
            return false;
        }
        if(StringUtils.isBlank(this.assets)){
            return false;
        }
        if(StringUtils.isBlank(this.caseIntro)){
            return false;
        }

        return true;
    }
}
