package cn.com.duiba.kjy.api.dto.singlefestival;

import lombok.Data;

import java.math.BigDecimal;

/**
 *
 * @author 吴文哲
 * @date 2019-10-26 17:49
 **/
@Data
public class FestivalAwardConfigDto {

    /**
     * 主键
     */
    private Long id;

    /**
     * 奖项名称
     */
    private String awardName;

    /**
     * 红包类型 1:代理人分享特殊红包 2:代理人分享必中红包 3:访客参与活动红包 4:访客参与活动降级红包
     */
    private Integer awardType;

    /**
     * 奖项最小中奖金额(单位分)
     */
    private Integer minAmount;

    /**
     * 奖项最大中奖金额(单位分)
     */
    private Integer maxAmount;

    /**
     * 奖品次序,数字越大奖品价值越小,与奖项类型关联
     */
    private Integer sequence;

    /**
     * 奖品数量(-1表示没有限制)
     */
    private Integer awardCount;

    /**
     * 已发放奖品数量
     */
    private Integer sendedCount;

    /**
     * 中奖概率
     */
    private BigDecimal probability;


    /**
     * 测试
     */
    private Integer random ;

}
