package cn.com.duiba.kjy.api.enums.content;

/**
 * @author wangbinbin
 * @create 2019-08-14 16:06
 * @descript
 */
public enum ContentInteractionTypeEnum {
    SINGLE_ANSWER((byte)0, "问答题单选"),
    MULTI_ANSWER((byte)1, "问答题多选"),
    SINGLE_VOTE((byte)2, "投票单选"),
    MULTI_VOTE((byte)3, "投票多选");

    private byte code;
    private String descript;

    ContentInteractionTypeEnum(byte code, String descript) {
        this.code = code;
        this.descript = descript;
    }

    public byte getCode() {
        return code;
    }

    public String getDescript() {
        return descript;
    }

    public static boolean isAnswer(byte code) {
        return code == SINGLE_ANSWER.getCode() || code == MULTI_ANSWER.getCode();
    }

}
