package cn.com.duiba.kjy.api.dto.newyear;

import com.google.common.collect.Lists;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-12-13 14:44
 * @descript
 */
@Data
public class NewYearActivityConfigDto implements Serializable {

    private static final long serialVersionUID = 6792018540616003775L;

    /**
     * 引流浮标id
     */
    private Integer buoyId = 1;

    /**
     * 引流浮标图片地址
     */
    private String buoyImageUrl = "";

    /**
     * 海报分享配文
     */
    private String posterShareContent = "";

    /**
     * 普通分享配文
     */
    private String normalShareContent = "";

    /**
     * 背景音乐列表
     */
    private List<String> musics = Lists.newArrayList();

    /**
     * 元旦活动id
     */
    private Long contentId = 0L;

    /**
     * 弹层样式
     */
    private Integer layerStyle = 1;

    /**
     * 转发后mq延迟消费时间 默认24小时
     */
    private Long forwardDelayMinutes = 24 * 60L;

    /**
     * 点赞后mq延迟消费时间 默认2秒
     */
    private Long likeDelaySeconds = 2L;

    /**
     * 上传图片最大值为20MB
     */
    private Float maxPhotoSize = 20 * 1024F;

    /**
     * 最大上传照片数
     */
    private Integer maxPhotoUploadNum = 50;

    /**
     * 引流自定义推送ids
     */
    private List<Long> newYearGetUserPushIds = Lists.newArrayList();

    /**
     * 引流弹层的图片地址
     */
    private List<NewYearLayerDto> layers = Lists.newArrayList();

    @Data
    public static class NewYearLayerDto implements Serializable {

        /**
         * 弹层开始出现的时间
         */
        private Long startTimestamp;

        /**
         * 弹层结束时间
         */
        private Long endTimestamp;

        /**
         * 弹层的图片地址
         */
        private String url;

        /**
         * 弹层的类型
         */
        private Integer type;

        /**
         * 编号
         */
        private Integer id;
    }

}
