/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.interaction;

import cn.com.duiba.kjy.api.enums.interaction.InteractionTypeEnum;
import java.util.HashMap;
import java.util.Map;

public enum InteractionSelectionTypeEnum {
    SINGLE(0, "\u5355\u9009"),
    MULTIPLE(1, "\u591a\u9009");

    private Integer type;
    private String desc;
    private static final Map<Integer, InteractionSelectionTypeEnum> ENUM_MAP;

    private InteractionSelectionTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static InteractionSelectionTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static InteractionSelectionTypeEnum getByInteractionType(Byte interactionType) {
        if (interactionType == null) {
            return null;
        }
        if (InteractionTypeEnum.isMultiple(interactionType)) {
            return MULTIPLE;
        }
        if (InteractionTypeEnum.isSingle(interactionType)) {
            return SINGLE;
        }
        return null;
    }

    static {
        ENUM_MAP = new HashMap<Integer, InteractionSelectionTypeEnum>();
        for (InteractionSelectionTypeEnum typeEnum : InteractionSelectionTypeEnum.values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }
}

