package cn.com.duiba.kjy.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.activity.detail.ContentActivityExtDetailDto;
import cn.com.duiba.kjy.api.params.ContentSearchParams;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.activity.ContentActivityExtParams;

import java.util.List;

/**
 * 活动相关
 * @author lizhi
 * @date 2019/10/28 9:51 AM
 */
@AdvancedFeignClient
public interface RemoteContentActivityService {

    /**
     * 分页查询活动及扩展信息-管理后端专用(不包含tb_content_ext表内容)
     * @param params 参数
     * @return 活动及扩展信息
     */
    Page<ContentActivityExtDetailDto> findPage(ContentActivityExtParams params);

    /**
     * 分页查询活动及扩展信息(不包含tb_content_ext表内容)
     * @param params 分页参数
     * @return 活动及扩展信息
     */
    List<ContentActivityExtDetailDto> findActivityPageList(ContentSearchParams params);

    /**
     * 分页查询活动及扩展信息(不包含tb_content_ext表内容)
     * @param params 分页参数
     * @return 活动及扩展信息及分页信息
     */
    Page<ContentActivityExtDetailDto> findActivityPage(ContentSearchParams params);

    /**
     * 分页查询抽奖模板及扩展信息(不包含tb_content_ext表内容)
     * @param params 分页参数
     * @return 抽奖模板及扩展信息
     */
    List<ContentActivityExtDetailDto> findGameTemplatePageList(ContentSearchParams params);

    /**
     * 根据ID从缓存查询活动及扩展信息
     * @param contentId tb_content表主键
     * @return 活动及扩展信息
     */
    ContentActivityExtDetailDto findGameByContentIdCache(Long contentId);

    /**
     * 新增或更新
     * @param dto 活动及扩展信息
     * @return tb_content表主键
     * @throws KjyCenterException 保存或更新发生异常
     */
    Long saveOrUpdate(ContentActivityExtDetailDto dto) throws KjyCenterException;
}
