package cn.com.duiba.kjy.api.remoteservice.redpacket;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.redpacket.SellerRedPacketConfDto;
import cn.com.duiba.kjy.api.dto.wechat.WxPayMpResponseDto;
import cn.com.duiba.kjy.api.params.redpacket.RedPacketCreateParam;
import cn.com.duiba.kjy.api.params.redpacket.SellerRedPacketConfParam;

import java.util.List;

/**
 * @author liuchao1
 * @date 2020/1/8 13:39
 */
@AdvancedFeignClient
public interface RemoteSellerRedPacketConfService {

    /**
     * 根据id查询
     * @param id 主键id
     * @return 红包配置信息
     */
    SellerRedPacketConfDto findById(Long id);

    /**
     * 根据业务订单号查询红包配置
     * @param bizOrderNo 业务订单号
     * @return 红包配置信息
     */
    SellerRedPacketConfDto findByBizOrderNo(String bizOrderNo);

    /**
     * 根据条件查询代理人红包配置
     * @param param 查询条件
     * @return 红包配置信息
     */
    List<SellerRedPacketConfDto> findByParam(SellerRedPacketConfParam param);

    /**
     * 根据业务id和业务类型查询最后一条数据
     * @param redPacketBizId
     * @param redPacketBizType
     * @return 代理人红包配置服务
     */
    SellerRedPacketConfDto getLastByBiz(Long redPacketBizId, Integer redPacketBizType);

    /**
     * 创建红包，调用兑吧下单
     * @param param 创建红包参数
     * @return 前端拉起支付框所需参数
     */
    WxPayMpResponseDto createRedPacket(RedPacketCreateParam param);

    /**
     * 根据业务订单号同步充值订单，若订单状态不在排除状态内，则同步订单，否则直接返回客集集支付状态
     * @param bizOrderNo 业务订单号
     * @param excludeChargeStatus 排除状态合集
     * @return 充值状态，可能是null
     */
    Integer syncOrderIfNeeded(String bizOrderNo, List<Integer> excludeChargeStatus);

    /**
     * 根据业务订单号取消红包配置
     * @param bizOrderNo 业务订单编号
     * @return 是否取消成功
     */
    boolean cancel(String bizOrderNo);
}
