package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author 吴文哲
 * @date 2019-08-31 16:02
 **/
@Data
public class SellerCustomerParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 8697470858119673274L;

    /**
     * 代理人Id
     *
     */
    private Long sellerId;

    /**
     * 客户意向度星级
     */
    private Integer star;

    /**
     * 客户意向度得分（0-5）
     */
    private Integer score;

    /**
     * 客户来源 1:微信好友 2:二度人脉
     */
    private Integer custOrigin;

    /**
     * 客户类型标记（2:访客，3：有意向，4：已签单，5：无意向）
     */
    private Integer custMark;

    /**
     * 相关线索：（0：全部，1：有资料，2：中奖，3：转发，4：答题，5：投票）
     */
    private Integer relatedClue;

    /**
     * 用户行为  详见 CusActionConvertor
     */
    private List<Integer> custActions;


    /**
     * 排序类型(0:默认排序(名字首字母),1:访问次数从高到低,2:访问次数从低到高,3:最近访问时间从近到远,4:最近访问时间从远到近)
     */
    private Integer sortType;


    /**
     * 查询成为客户的开始时间
     */
    private Date startDate;

    /**
     * 查询成为客户的结束时间
     */
    private Date endDate;

}
