package cn.com.duiba.kjy.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.invitation.SellerInvitationLetterDto;
import cn.com.duiba.kjy.api.params.invivation.SellerInvivationParam;

import java.util.List;

/**
 * 代理人邀请函
 * @author 吴文哲
 * @date 2019-12-06 11:41
 **/
@AdvancedFeignClient
public interface RemoteSellerInvitationLetterService {

    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer getSellerInvitationCountByCondition(SellerInvivationParam param);

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<SellerInvitationLetterDto> getSellerInvitationListByCondition(SellerInvivationParam param);

    /**
     * 新增邀请函
     * @param addDto
     * @return
     */
    Long addSellerInvitation(SellerInvitationLetterDto addDto);

    /**
     * 更新邀请函
     * @param updateDto
     * @return
     */
    Integer updateSellerInvitation(SellerInvitationLetterDto updateDto);

    /**
     * 根据主键id获取
     * @param id
     * @return
     */
    SellerInvitationLetterDto getSellerInvitationById(Long id);

    /**
     * 根据预生成id获取
     * @param invitationUUId
     * @return
     */
    SellerInvitationLetterDto getSellerInvitationByUUId(String invitationUUId);

    /**
     * 批量获取
     * @param ids
     * @return
     */
    List<SellerInvitationLetterDto> getSellerInvitationByIds(List<Long> ids);




}
