package cn.com.duiba.kjy.api.dto.fission;

import cn.com.duiba.kjy.api.enums.fission.FissionChatTypeEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Data
@ToString
public class FissionChatRecordDto implements Serializable {

    private static final long serialVersionUID = 4900225431909440379L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 会话流程id
     */
    private String flowId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动参与记录id
     */
    private Long partakeRecordId;

    /**
     * 发送方用户id
     */
    private Long senderUserId;

    /**
     * 接收方用户id
     */
    private Long receiveUserId;

    /**
     * 消息阶段
     */
    private Integer chatStage;

    /**
     * 已读标识 1 = 已读，0 =未读
     */
    private Integer readFlag;

    /**
     * 聊天类型
     * @see FissionChatTypeEnum
     */
    private Integer chatType;

    /**
     * 奖品消息id,对应tb_award_context.id
     */
    private Long awardContextId;

    /**
     *  消息文案
     */
    private String contentText;

    /**
     *  按钮文案
     */
    private String buttonText;

    /**
     * 模板类型
     * @see cn.com.duiba.kjy.api.enums.fission.FissionAwardContextTemplateEnum
     */
    private Integer templateType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}