package cn.com.duiba.kjy.api.enums.fission;

import java.util.HashMap;
import java.util.Map;

/**
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年11月01日 11:55
 **/
public enum FissionAwardHaltedEnum {

    NOT_OPEN(0, "未启用"),

    OPEN(1, "已启用"),

    ;
    private Integer value;
    private String text;

    FissionAwardHaltedEnum(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    private static final Map<Integer, FissionAwardHaltedEnum> ENUM_MAP = new HashMap<>();

    static{
        for(FissionAwardHaltedEnum haltedEnum : values()){
            ENUM_MAP.put(haltedEnum.getValue(), haltedEnum);
        }
    }

    public static FissionAwardHaltedEnum getByValue(Integer value) {
        if (value == null) {
            return null;
        }
        return ENUM_MAP.get(value);
    }

    public Integer getValue() {
        return value;
    }

    public String getText() {
        return text;
    }
}
