package cn.com.duiba.kjy.api.enums.marketing;

import cn.com.duiba.kjy.api.enums.lottery.CouponStateEnum;
import cn.com.duiba.kjy.api.enums.lottery.CustomPrizeTypeEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/2/22 16:51
 */
public enum MarketingGiftStateEnum {

    AVAILABLE(1, "上架"),
    INVALID(2, "下架"),

    ;

    private int code;
    private String desc;

    MarketingGiftStateEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, MarketingGiftStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(MarketingGiftStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static MarketingGiftStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
