package cn.com.duiba.kjy.api.dto.invitationLetter;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户访问邀请函记录表
 * @author kjj mybatis generator 
 * 2020-02-18
 */
@Data
public class InvitationLetterRecordDto implements Serializable {
    private static final long serialVersionUID = 15820119879715184L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *邀请函ID，对应tb_content.id
     * not null default = null
     */
    private Long contentId;

    /**
     *
     *销售员id，对应tb_seller.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *用户ID(销售员)，对应 tb_users.id
     * not null default = null
     */
    private Long sellerUserId;

    /**
     *
     *邀请函配置ID，对应tb_seller_invitation_letter_conf.id
     * not null default = null
     */
    private Long confId;

    /**
     *
     *用户ID(访问者)，对应 tb_users.id
     * not null default = null
     */
    private Long visitorId;

    /**
     *
     *受邀人姓名
     * max length = 30
     */
    private String visitorName;

    /**
     *
     *受邀人联系电话
     * max length = 30
     */
    private String visitorPhone;

    /**
     *
     *阅读标志：0=未读、1=已读
     * not null default = 0
     */
    private Integer readMark;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 行为
     * @see cn.com.duiba.kjy.api.enums.invitation.InvitationActionTypeEnum
     */
    private Integer actionType;
}