/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.pay;

import java.util.HashMap;
import java.util.Map;

public enum ChargeStatusEnum {
    INIT(0, "\u521d\u59cb\u5316\u72b6\u6001"),
    ORDER_SUCCESS(1, "\u7b2c\u4e09\u65b9\u652f\u4ed8\u6536\u5355\u6210\u529f"),
    ORDER_FAIL(2, "\u7b2c\u4e09\u65b9\u652f\u4ed8\u6536\u5355\u5931\u8d25"),
    PAY_SUCCESS(4, "\u652f\u4ed8\u6210\u529f"),
    PAY_FAIL(3, "\u652f\u4ed8\u5931\u8d25"),
    PAY_REVERSED(5, "\u652f\u4ed8\u53d6\u6d88"),
    REFUNDING(6, "\u9000\u6b3e\u4e2d"),
    REFUND_SUCCESS(7, "\u9000\u6b3e\u6210\u529f"),
    REFUND_FAIL(8, "\u9000\u6b3e\u5931\u8d25"),
    KJJ_CREATE_PAY_RECORD_FAIL(21, "\u751f\u6210\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25"),
    KJJ_DUIBA_ERROR(22, "\u8c03\u7528\u7b2c\u4e09\u65b9\u5931\u8d25");

    private Integer code;
    private String desc;
    private static final Map<Integer, ChargeStatusEnum> ENUM_MAP;

    private ChargeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public static ChargeStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static boolean isPaySuccess(Integer code) {
        ChargeStatusEnum statusEnum = ChargeStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == PAY_SUCCESS;
    }

    public static boolean isPayFail(Integer code) {
        ChargeStatusEnum statusEnum = ChargeStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == KJJ_CREATE_PAY_RECORD_FAIL || statusEnum == KJJ_DUIBA_ERROR || statusEnum == ORDER_FAIL || statusEnum == PAY_FAIL;
    }

    public static boolean canCancel(Integer code) {
        ChargeStatusEnum statusEnum = ChargeStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == INIT || statusEnum == ORDER_SUCCESS;
    }

    public static boolean isPayCancel(Integer code) {
        ChargeStatusEnum statusEnum = ChargeStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == PAY_REVERSED;
    }

    public static boolean isRefund(Integer code) {
        ChargeStatusEnum statusEnum = ChargeStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == REFUNDING || statusEnum == REFUND_FAIL || statusEnum == REFUND_SUCCESS;
    }

    public static boolean isPayFinal(Integer code) {
        ChargeStatusEnum statusEnum = ChargeStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return ChargeStatusEnum.isPayFail(code) || ChargeStatusEnum.isPaySuccess(code) || ChargeStatusEnum.isPayCancel(code) || ChargeStatusEnum.isRefund(code);
    }

    static {
        ENUM_MAP = new HashMap<Integer, ChargeStatusEnum>();
        for (ChargeStatusEnum tmp : ChargeStatusEnum.values()) {
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }
}

