package cn.com.duiba.kjy.api.enums;

/**
 * @author zhanghuifeng
 * date 2019-04-17-17:08
 */
public enum CompanyItemTypeEnum {

    CONTENT(1, "内容"),
    MARKET(2, "营销位"),
    COLLECTION(3, "收藏/爬虫内容"),
    ;
    private int code;

    private String desc;

    CompanyItemTypeEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static CompanyItemTypeEnum getByCode(int code) {
        for (CompanyItemTypeEnum enumVal : CompanyItemTypeEnum.values()) {
            if (enumVal.getCode()==code) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(int code) {
        for (CompanyItemTypeEnum enumVal : CompanyItemTypeEnum.values()) {
            if (enumVal.getCode() == code) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
