package cn.com.duiba.kjy.api.dto.grabmaterial;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 发圈素材
 * @author kjj mybatis generator 
 * 2020-03-09
 */
@Data
public class MaterialContentExtDto implements Serializable {
    private static final long serialVersionUID = 15837439665128761L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *素材类型
     * not null default = null
     */
    private Integer materialType;

    /**
     *
     *tb_content表id
     * not null default = null
     */
    private Long contentId;

    /**
     *
     *tb_content.id，文章/动画/测试id源
     */
    private Long sourceContentId;

    /**
     *
     *内容，朋友圈配文
     * max length = 125
     */
    private String content;

    /**
     *
     *原图
     * max length = 512
     */
    private String sourceImg;

    /**
     *
     *发圈素材标签,tb_material_tag.id
     * not null default = null
     */
    private Long materialTag;

    /**
     *
     *推荐优先级 1低，2中，3高
     * not null default = null
     */
    private Integer recommendPriority;

    /**
     *
     *评论，json格式
     * max length = 1024
     */
    private String comments;

    /**
     *
     *转发人数级别 1低，2中，3高
     * not null default = null
     */
    private Integer forwardRank;

    /**
     *
     *视频
     * max length = 512
     */
    private String sourceVideo;

    /**
     *
     *链接封面图
     * max length = 125
     * not null default = null
     */
    private String videoImg;

    /**
     *
     *链接标题
     * max length = 125
     * not null default = null
     */
    private String videoTitle;

    /**
     *
     *原文地址
     * max length = 255
     */
    private String sourceUrl;

    /**
     *
     *状态，1=草稿、2=正常,跟tb_content表同步
     * not null default = 1
     */
    private Integer status;
    /**
     * 转发数
     */
    private Integer forwardNum;

    /**
     *
     *是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Integer deleted;

    /**
     * 发布时间点（小时）
     */
    private Date releaseTimeHour;

    /**
     *
     *是否置顶，1=已置顶，0=未置顶
     * not null default = 0
     */
    private Byte topContent;

    /**
     *  置顶时间点
     */
    private Date topTime;


    /**
     * 评论人昵称 与comments每个评论一一对应
     */
    private String commentsPerson;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}